import { Router } from 'express';
import { greetingsController } from './controller';
import { authenticateUser, requireVendor } from '@/middlewares/auth';
import { checkFeature } from '@/middlewares/featureGate';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    req.vendor = vendor || null;
  }
  next();
}

// Create or update greeting template
router.post('/templates', authenticateUser, requireVendor, attachVendor, checkFeature('greeting_scheduler'), greetingsController.upsertTemplate);
// Get all templates
router.get('/templates', authenticateUser, requireVendor, attachVendor, checkFeature('greeting_scheduler'), greetingsController.getTemplates);
// Update greeting settings
router.patch('/settings', authenticateUser, requireVendor, attachVendor, checkFeature('greeting_scheduler'), greetingsController.updateSettings);
// Get greeting logs
router.get('/logs', authenticateUser, requireVendor, attachVendor, checkFeature('greeting_scheduler'), greetingsController.getLogs);

export default router; 